/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa.eventlog;

import filenet.pa.sql.PAPEPartition;
import filenet.vw.apps.taskman.images.VWImageLoader;
import filenet.vw.apps.taskman.pa.eventlog.EventLogBaseNode;
import filenet.vw.apps.taskman.pa.eventlog.EventLogNode;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.tree.TreeNode;

public class EventLogRegionNode
extends EventLogBaseNode {
    private EventLogNode m_allEventLogNode = null;
    private int m_region;
    private boolean m_isNew = false;
    private static final ImageIcon ICON = VWImageLoader.createImageIcon("region_16.gif");

    public EventLogRegionNode(int region) {
        super(VWResource.RegionNumber.toString(new Integer(region)), ICON);
        this.m_region = region;
        this.m_allEventLogNode = new EventLogNode(new PAPEPartition(region, null), true);
        this.add(this.m_allEventLogNode);
    }

    public void setSelected(boolean selected) {
        super.setSelected(selected);
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            EventLogNode node = (EventLogNode)e.nextElement();
            if (node.isAllEventLog()) {
                node.setSelected(selected && node.isEnabled());
                continue;
            }
            node.setSelected(selected);
        }
    }

    public EventLogNode getAllEventLogNode() {
        return this.m_allEventLogNode;
    }

    public EventLogNode getEventLogNode(String logName) {
        if (logName == null) {
            return this.getAllEventLogNode();
        }
        Enumeration<TreeNode> e = this.children();
        while (e.hasMoreElements()) {
            EventLogNode node = (EventLogNode)e.nextElement();
            if (!logName.equals(node.getLogName())) continue;
            return node;
        }
        return null;
    }

    public int getRegion() {
        return this.m_region;
    }
}

